/*
 * window_main.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * gkexec is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * gkexec is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 

#ifndef __WINDOW_MAIN_H__
#define __WINDOW_MAIN_H__

#include <gtkmm.h>

class ButtonBox;

class WindowMain : public Gtk::Dialog
{
public:
	
	WindowMain(char**);  
	virtual ~WindowMain();

private:	
	//Signal handlers:
	//void on_checkbox_editable_toggled();
	void on_checkbox_visibility_toggled();
	void clear_entry_box();
  
	void on_button_close();
	void on_button_execute(char **argv);  /* argv unused so far */
	
	//void on_checkbutton_activity();
	bool m_bActivityMode;
  
	//Child widgets:
	Gtk::VBox 		 *m_VBox;
	Gtk::Label 		  m_Label;
	Gtk::Entry 	   	  m_Entry;
	Gtk::Button      *m_Button_Execute;
	Gtk::Button      *m_Button_Close;
	Gtk::CheckButton *m_CheckButton_Visible = NULL;	
	Gtk::CheckButton  m_CheckButton_Activity;
};

#endif //__WINDOW_MAIN_H__
