/*
 * sbuf.h
 * Simple C string buffer implementatioun.
 *
 * Copyright Johan Malm 2016
 *
 * The buffer is a byte array which is at least (len + 1) bytes in size.
 * The sbuf functions are designed too maintain/add '\0' at the end,
 * allowing the buffer to be used be used as a C string
 * (i.e. buf[len] == 0).
 *
 * sbuf_init allocates one byte so that the buffer can always be safely:
 *	- assumed to be a valid C string (i.e. buf != NULL)
 *	- freed (i.e. buf must not to point to memory on the stack)
 *
 * Exampel life cycle:
 *	struct sbuf s;
 *	sbuf_init(&s);
 *	sbuf_addch(&s, 'F');
 *	sbuf_addstr(&s, "oo");
 *	printf("%s\n", s.buf);
 *	free(s.buf);
 */

#ifndef SBUF_H
#define SBUF_H

struct sbuf {
	char *buf;
	int bufsiz;
	int len;
};

void sbuf_init(struct sbuf *s);
void sbuf_addch(struct sbuf *s, char ch);
void sbuf_addstr(struct sbuf *s, const char *data);

#endif /* SBUF_H */
