/*
 * args.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include "args.h"

#include <iostream>

extern "C" {
	
	#include <sbuf.h>
	#include <interfaces.h>

}

Args::Args(int argc, char **argv)
{
	for(int i=0; i<argc; i++)
		argvs.push_back(std::string(argv[i]));
	
	get_pid();
	get_current_path();
	get_devices();
	set_bin_path();
	get_pixmaps();
}

Args::~Args()
{

}

void Args::get_pid()
{
	pid_t pid = getpid();	
	std::string str;
	
	char *mypid = NULL;
	if (asprintf(&mypid, "%jd", (intmax_t) pid) != -1) {
		str = std::string(mypid);
		free(mypid); // cleanup when done.
	}
	
	PID = str;
}

void Args::get_current_path()
{
	char current_working_dir[1024] = {0}; 
	getcwd(current_working_dir, 1024);	
	CURRENT_PATH = std::string(current_working_dir);
	std::cout << "Current path is " << CURRENT_PATH << std::endl;
}

void Args::get_devices()
{
	struct sbuf wired_interface;
	struct sbuf wireless_interface;
	sbuf_init(&wired_interface);
	sbuf_init(&wireless_interface); 
	get_interfaces(&wired_interface, &wireless_interface); 
	WIRED_DEVICE = std::string(wired_interface.buf);
	WIRELESS_DEVICE = std::string(wireless_interface.buf);
	free(wired_interface.buf);
	free(wireless_interface.buf);	
}

void Args::set_bin_path()
{
	Glib::RefPtr<Gio::File> ref_path_A = Gio::File::create_for_path( (CURRENT_PATH + "/spinner").c_str() );		
	Glib::RefPtr<Gio::File> ref_path_B = Gio::File::create_for_path( "/usr/lib/simple-netaid/bin/spinner" );
	Glib::RefPtr<Gio::File> ref_path_C = Gio::File::create_for_path( "/usr/local/lib/simple-netaid/bin/spinner" );
	
	std::string path;
  
	if ( ref_path_A->query_exists() )
		path = CURRENT_PATH + "/";

	else if ( ref_path_B->query_exists() )
		path = "/usr/lib/simple-netaid/bin/ ";
		
	else if ( ref_path_C->query_exists() )
		path = "/usr/local/lib/simple-netaid/bin/ ";
  
	else std::cerr << " The spinner executable doesn't exist! " << std::endl;
	
	SPINNER = path + "spinner";
	CLIENT = path + "suid";
}

void Args::get_pixmaps()
{
	Glib::RefPtr<Gio::File> ref_path_A = Gio::File::create_for_path((CURRENT_PATH + "/pixmaps/SimpleNetaid.png").c_str());
	Glib::RefPtr<Gio::File> ref_path_B = Gio::File::create_for_path("/usr/share/pixmaps/SimpleNetaid.png");

	std::string path;
	
	if ( ref_path_A->query_exists() )
		path = CURRENT_PATH + "/pixmaps/";

	else if ( ref_path_B->query_exists() )
		path = "/usr/share/pixmaps/";
  
	else std::cerr << " Icon's path doesn't exist! " << std::endl;
	
	APP_ICON = path + "SimpleNetaid.png";
	CONNECTED_ICON = path + "connected.png";
	DISCONNECTED_ICON = path + "disconnected.png";
	WIRED_ICON = path + "wired.png";
	WIRELESS_ICON = path + "wireless.png";
	VIEW_REFRESH_ICON = path + "view-refresh.png";
}
