/*
 * args.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 

#ifndef __ARGS_H__
#define __ARGS_H__

#include <gtkmm.h>

class Args
{  
public:
	Args(int, char**);
	virtual ~Args();
		
	virtual void get_pid();
	virtual void get_current_path();
	virtual void get_devices();
	virtual void set_bin_path();
	virtual void get_pixmaps();
	
	std::vector<std::string> argvs;
	
	std::string PID;
	std::string CURRENT_PATH;							 
	std::string ARGS_FILE_DESCRIPTOR;
	std::string WIRED_DEVICE;
	std::string WIRELESS_DEVICE;
	std::string APP_ICON;
	std::string CONNECTED_ICON;
	std::string DISCONNECTED_ICON;
	std::string WIRED_ICON;
	std::string WIRELESS_ICON;
	std::string VIEW_REFRESH_ICON;
	std::string SPINNER;
	std::string CLIENT;
};

#endif // __ARGS_H__
