/*
 * cli.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 
#include "cli.h"

Cli::Cli(std::string fileDescriptor)
{
	puntSockServer = (struct sockaddr*) &dirUNIXServer;  
	longServer = sizeof(dirUNIXServer);
	
	// Create a bidirectional UNIX socket:
	dfClient = socket ( AF_UNIX, SOCK_STREAM, PROTOCOL );
	dirUNIXServer.sun_family = AF_UNIX;    /* domain type */  
	strcpy(dirUNIXServer.sun_path, fileDescriptor.c_str());   /* name of the server */

	int n=0;
	while(1) {  
		int result = connect(dfClient, puntSockServer, longServer);  
		if(result == -1 && n<10) {
			sleep (1);   /* retry */
			n++;
		} else break;
	}
	
	/* close the file descriptor */
	std::vector<std::string>::iterator iter;
	iter = messages.begin();	
	while(readMessage()) iter++;	
}

Cli::~Cli()
{
	close(dfClient);      /* close the socket */
	std::cout << "Cli::~Cli" << std::endl;
}

int Cli::readMessage()
{
	char *buffer, *cad;
	
	buffer = (char*)malloc(1);
	buffer[0] = '\0';
		
	cad = (char*)malloc(1);
	cad[0] = '\0';
	
	int n, buffer_size = 1, len = 0;
	
	do {						
		n = read (dfClient, cad, 1);
		
		if (buffer_size <= len + 1) {
			buffer_size = buffer_size * 2 + 16;
			buffer = (char*)realloc(buffer, buffer_size);
		}
	
		buffer[len++] = *cad;
		buffer[len] = 0;
		
	} while (n > 0 && *cad++);	
	
	if(n > 0) messages.push_back(buffer);
	
	free(buffer);
	
	return (n > 0);
}
