/*
 * cli.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#ifndef __CLI_H__
#define __CLI_H__

#include <iostream>
#include <vector>
#include <unistd.h>
#include <signal.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>      /* for UNIX sockets */

#define PROTOCOL 0       /* protocol by  default */

class Cli
{
public:
	Cli(std::string);
	virtual ~Cli();
	
	std::vector<std::string> messages;
  
private:
	int    longServer, dfClient;  
	struct sockaddr_un dirUNIXServer;  
	struct sockaddr* puntSockServer;
	
	int readMessage();
};


#endif // __CLI_H__
