/*
 * icon_factory.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include "icon_factory.h"

#include <iostream>

IconFactory::IconFactory()
{
	set_stock_icons();
	register_stock_icons();
}

IconFactory::~IconFactory()
{
	
}

void IconFactory::set_stock_icons()
{
	Glib::RefPtr<Gio::File> ref_path_A = Gio::File::create_for_path("./pixmaps/SimpleNetaid.png" );
	Glib::RefPtr<Gio::File> ref_path_B = Gio::File::create_for_path( "/usr/share/pixmaps/SimpleNetaid.png" );

	std::string path;
	
	if ( ref_path_A->query_exists() )
		path = "./pixmaps/";

	else if ( ref_path_B->query_exists() )
		path = "/usr/share/pixmaps/";
  
	else std::cerr << " Icon's path doesn't exist! " << std::endl;	
	
	VIEW_REFRESH_ICON = path + "view-refresh.png";
	WIRED_ICON = path + "wired.png";
	WIRELESS_ICON = path + "wireless.png";
}

void IconFactory::register_stock_icons()
{
	Glib::RefPtr<Gtk::IconFactory> factory = Gtk::IconFactory::create();
		
	add_stock_icon(factory, VIEW_REFRESH_ICON, "refresh", "Refresh");
	add_stock_icon(factory, WIRED_ICON, "wired connection", "Wired connection");
	add_stock_icon(factory, WIRELESS_ICON, "wireless", "Wireless connection");
	
	factory->add_default(); //Add factory to list of factories.
	
	this->REFRESH_STOCK_ICON = Gtk::StockID("refresh");
	this->WIRED_STOCK_ICON = Gtk::StockID("wired connection");
	this->WIRELESS_STOCK_ICON = Gtk::StockID("wireless");
}

void IconFactory::add_stock_icon( const Glib::RefPtr<Gtk::IconFactory> &factory,
								  const std::string& filepath,								  
                                  const std::string& id,
                                  const std::string& label )
{	
	Gtk::IconSource source;
	
	try
	{
		//This throws an exception if the file is not found:
		//source.set_pixbuf(Gdk::Pixbuf::create_from_file(filepath));
		const Glib::RefPtr<Gdk::Pixbuf>& pixbuf = Gdk::Pixbuf::create_from_file(filepath);
		source.set_pixbuf(pixbuf);
	}
	catch(const Glib::Exception& ex)
	{
		std::cout << ex.what() << std::endl;
	}

	source.set_size(Gtk::ICON_SIZE_SMALL_TOOLBAR);
	source.set_size_wildcarded(); //Icon may be scaled.

	Gtk::IconSet icon_set;
	icon_set.add_source(source); //More than one source per set is allowed.

	const Gtk::StockID stock_id(id);
	factory->add(stock_id, icon_set);
	Gtk::Stock::add(Gtk::StockItem(stock_id, label));
}
