/*
 * icon_factory.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 

#ifndef __ICON_FACTORY_H__
#define __ICON_FACTORY_H__

#include <gtkmm.h>

class IconFactory
{  
public:
	IconFactory();
	virtual ~IconFactory();
	
protected:
	//Child widgets:	
	Gtk::StockID REFRESH_STOCK_ICON;
	Gtk::StockID WIRED_STOCK_ICON;
	Gtk::StockID WIRELESS_STOCK_ICON;
	
	std::string WIRED_ICON;
	std::string WIRELESS_ICON;
	std::string VIEW_REFRESH_ICON;
	
	virtual void set_stock_icons();
	virtual void register_stock_icons();
	virtual void add_stock_icon( const Glib::RefPtr<Gtk::IconFactory>&,
								 const std::string&,
								 const std::string&,
								 const std::string& );
	
	// Friend classes:							 
	friend class myMenuBar;
	friend class myToolbar;
};

#endif // __ICON_FACTORY_H__
