/*
 * menubar.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include <gtkmm.h>
#include <iostream>

#include "menubar.h"
#include "window_main.h"
#include "args.h"
#include "icon_factory.h"

myMenuBar::myMenuBar(WindowMain *caller, std::unique_ptr<Args>& args)
{
	IconFactory *m_IconFactory = new IconFactory();

	item = Gtk::manage(new Gtk::ImageMenuItem("Menu", true));
	append(*item);
	m_Menu = Gtk::manage(new Gtk::Menu());
	item->set_submenu(*m_Menu);
	
	m_WiredConnectionItem = Gtk::manage(new Gtk::ImageMenuItem(m_IconFactory->WIRED_STOCK_ICON));
	m_Menu->append(*m_WiredConnectionItem);
	
	m_WiredConnectionItem->signal_activate().connect (
		sigc::bind<WindowMain*, std::unique_ptr<Args>&>
		(
			sigc::mem_fun(*this, &myMenuBar::on_action_connect),
			caller,
			args
		)
	);
	
	m_DisconnectItem = Gtk::manage( new Gtk::ImageMenuItem(Gtk::Stock::DISCONNECT));
	m_Menu->append(*m_DisconnectItem);
	m_DisconnectItem->signal_activate().connect (
		sigc::bind<WindowMain*, std::unique_ptr<Args>&>
		(			
			sigc::mem_fun(*this, &myMenuBar::on_action_disconnect),
			caller,
			args
		)
	);
	
	hline = Gtk::manage(new Gtk::SeparatorMenuItem());
	m_Menu->append(*hline);
  
	item = Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::QUIT));
	m_Menu->append(*item);
	item->signal_activate().connect (
		sigc::bind<WindowMain*>
		(
			sigc::mem_fun(*this, &myMenuBar::on_action_quit),
			caller
		)
	); 
	
	// Define the items of the second Menu:
	item = Gtk::manage(new Gtk::ImageMenuItem("Help", true));
	append(*item);
	m_Menu = Gtk::manage(new Gtk::Menu());
	item->set_submenu(*m_Menu);	
	
	item = Gtk::manage(new Gtk::ImageMenuItem(Gtk::Stock::ABOUT));
	m_Menu->append(*item);
	item->signal_activate().connect (
		sigc::mem_fun(*this, &myMenuBar::on_about_button_clicked)
	);
	
	m_Menu->show_all();
	
	if(m_IconFactory) delete m_IconFactory;
}

myMenuBar::~myMenuBar()
{
	if(m_Menu) delete m_Menu;
}

void myMenuBar::on_action_connect(WindowMain *caller, std::unique_ptr<Args>& args)
{
}

void myMenuBar::on_action_disconnect(WindowMain *caller, std::unique_ptr<Args>& args)
{
}

void myMenuBar::on_action_quit(WindowMain *caller)
{
	delete caller;
}

void myMenuBar::on_about_button_clicked()
{
}
