/*
 * pipe_file.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include "pipe_file.h"
#include <iostream>
#include <stdexcept>

extern "C" {
	
	#include <sbuf.h>

}

PipeFile::PipeFile()
{

}

PipeFile::~PipeFile()
{

}

std::vector<std::string> PipeFile::get_output(std::string cmd)
{    
    std::vector<std::string> buffer;
	
	try {
		
		char ch;
		struct sbuf s;
		sbuf_init(&s);
		
		FILE *fpipe = (FILE*)popen(cmd.c_str(), "r");
		
		while ((ch = fgetc(fpipe)) != EOF) {			
			if(ch != '\n') sbuf_addch(&s, ch);
			else {
				buffer.push_back(std::string(s.buf));
				sbuf_init(&s);
			}
		}
		
		pclose(fpipe);
		free(s.buf);
		
	} catch(std::exception const& e){
		
		throw std::runtime_error("Sorry there was an error opening the file\n");		
	};
	
	// std::vector<std::string>::iterator iter = buffer.begin();
	// for(; iter != buffer.end(); iter++) std::cout << *iter << std::endl;
	
	return buffer;
}
