/*
 * srv.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include <iostream>
#include <string>
#include <vector>
#include "srv.h"

Srv::Srv(const std::vector<std::string> &args)
{
	std::vector<std::string> messages;
	
	for (const std::string &str : args)
		messages.push_back(str);

	sigc::slot<void>
		op_send = sigc::bind< std::vector<std::string> >
				(
					sigc::mem_fun(*this, &Srv::send_messages),
					messages
				);  
  
	thread = Glib::Threads::Thread::create(op_send);
}

Srv::~Srv()
{
	if(thread) {
				thread->join();
				thread = nullptr;
	}
        
	close(dfClient);      /* close the file descriptor in the parent */	
	std::cout << "Srv::~Srv" << std::endl;
}

void Srv::send_messages(std::vector<std::string> messages)
{
	puntSockServer = (struct sockaddr*) &dirUNIXServer;  
	longServer = sizeof(dirUNIXServer);  
	puntSockClient = (struct sockaddr*) &dirUNIXClient;  
	longClient = sizeof(dirUNIXClient);
	   
	signal(SIGCHLD, SIG_IGN);    /*  avoid zombies */
	
	std::vector<std::string>::iterator iter;
	iter = messages.begin();
	
	// Create a bidirectional UNIX socket:
	dfServer = socket ( AF_UNIX, SOCK_STREAM, PROTOCOL );                   
	dirUNIXServer.sun_family = AF_UNIX;   /* domain type */      
	strcpy(dirUNIXServer.sun_path, (*iter).c_str());   /* name of the client */  
	unlink((*iter).c_str()); 
	 
	// Create the file descriptor, that is, the socket: 
	bind(dfServer, puntSockServer, longServer);
                                          
	// Wait for the request of the client: 
	listen(dfServer, 5);  
  
	// Accept the connection
	dfClient = accept(dfServer, puntSockClient, &longClient);

	// create the child and send the file descriptor
	iter++;
	if (fork() == 0) 
		for (; iter < messages.end(); iter++)
			write(dfClient, (*iter).c_str(), strlen((*iter).c_str()) + 1);
}

                              	


