/*
 * srv.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#ifndef __SRV_H__
#define __SRV_H__

#include <glibmm.h>
#include <thread>
#include <unistd.h>
#include <signal.h>  
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/un.h>      /* for UNIX sockets */

#define PROTOCOL 0       /* protocol by default */

class Srv
{
public:
	Srv(const std::vector<std::string>&);
	virtual ~Srv();
  
private:
	Glib::Threads::Thread *thread;
	
	std::string fileDescriptor;
	int dfServer, dfClient; 
	socklen_t longServer, longClient; 

	struct sockaddr_un dirUNIXServer;  
	struct sockaddr_un dirUNIXClient;  

	struct sockaddr* puntSockServer;  
	struct sockaddr* puntSockClient;
	
	void send_messages(std::vector<std::string>); 
};

#endif // __SRV_H__
