/*
 * statusicon.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include <gtkmm.h>
#include <iostream>

#include "statusicon.h"
#include "window_main.h"
#include "args.h"
#include "popup.h"

myStatusIcon::myStatusIcon(WindowMain *caller, std::unique_ptr<Args>& args)
{
	m_PopupMenu = new myPopup(caller, args);
	
	// Setting up the StatusIcon:
	m_refStatusIcon = Gtk::StatusIcon::create_from_file(args->APP_ICON);
	m_refStatusIcon->set_tooltip_text("Disconnected");
	  
	// StatusIcon's signals (GTK+)
	GtkStatusIcon* gobj_StatusIcon = m_refStatusIcon->gobj();
	g_signal_connect(G_OBJECT(gobj_StatusIcon), "activate", G_CALLBACK(on_statusicon_activated), caller);
	g_signal_connect(G_OBJECT(gobj_StatusIcon), "popup-menu", G_CALLBACK(on_statusicon_popup), this);
}

myStatusIcon::~myStatusIcon()
{
	if(m_PopupMenu) delete m_PopupMenu;
}

void myStatusIcon::display_menu(guint button, guint32 activate_time)
{
	// Display the popupmenu:
	m_PopupMenu->show_popup_menu(button, activate_time);
}

/* * 
 *
 *  Gtk+ method:
 *
 */ 

void on_statusicon_activated(GtkWidget* widget, gpointer object)
{
	WindowMain* window_main = static_cast<WindowMain*>(object);
	bool hided = window_main->get_skip_taskbar_hint();
	hided ? window_main->deiconify() : window_main->iconify();
	
	if(hided) {
		
		window_main->set_skip_taskbar_hint(not hided);
			  	
		/* *
		 * 
		 *    Do something more here...
		 * 
		 */
	}
}

// This wraps the statusicon signal "popup-menu" and calls WindowMain::show_popup_menu()
void on_statusicon_popup(GtkStatusIcon* status_icon,
						 guint button,
						 guint32 activate_time,
						 gpointer object)
{
	return static_cast<myStatusIcon*>(object)->display_menu(button, activate_time);
}
