/*
 * toolbar.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */

#include <gtkmm.h>
#include <iostream>

#include "toolbar.h"
#include "popup.h"
#include "window_main.h"
#include "args.h"
#include "icon_factory.h"

myToolbar::myToolbar(WindowMain *caller, std::unique_ptr<Args>& args)
{
	IconFactory *m_IconFactory = new IconFactory();
	
	Glib::RefPtr<Gtk::Action>
		actionRefresh = Gtk::Action::create("Refresh", m_IconFactory->REFRESH_STOCK_ICON, "Refresh", "Refresh the list of active wifis");
	this->append(*(actionRefresh->create_tool_item()));	
		
	Glib::RefPtr<Gtk::Action>
		actionWiredConnection = Gtk::Action::create("Wired", m_IconFactory->WIRED_STOCK_ICON, "Wired", "Wired connection");
	this->append(*(actionWiredConnection->create_tool_item()));
		
	this->append(*(Gtk::manage(new Gtk::SeparatorToolItem)));
		
	Glib::RefPtr<Gtk::Action>
		actionQuit = Gtk::Action::create("quit", Gtk::Stock::QUIT, "Quit", "Close the application");
    this->append(*(actionQuit->create_tool_item()));
    
    this->get_nth_item(0)->set_receives_default(false);
    
    actionRefresh->signal_activate().connect
	(
		sigc::bind<WindowMain*, std::unique_ptr<Args>&>
		(
			sigc::mem_fun(*this, &myToolbar::on_action_refresh),
			caller,
			args
		)
	);
    
    actionWiredConnection->signal_activate().connect
	(
		sigc::bind<WindowMain*, std::unique_ptr<Args>&>
		(
			sigc::mem_fun(*this, &myToolbar::on_action_connect),
			caller,
			args
		)
	);
    
    actionQuit->signal_activate().connect
	(
		sigc::bind<WindowMain*>
		(
			sigc::mem_fun(*this, &myToolbar::on_action_quit),
			caller
		)
	);
	
	this->show_all();
	
	if(m_IconFactory) delete m_IconFactory;
}

myToolbar::~myToolbar()
{
	
}

void myToolbar::on_action_refresh(WindowMain *caller, std::unique_ptr<Args>& args)
{

}

void myToolbar::on_action_connect(WindowMain *caller, std::unique_ptr<Args>& args)
{

}

void myToolbar::on_action_quit(WindowMain *caller)
{
	delete caller;
}
