/*
 * window_main.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 

#include <gtkmm.h>
#include <iostream>

#include "window_main.h"
#include "args.h"
#include "statusicon.h"
#include "menubar.h"
#include "toolbar.h"

WindowMain::WindowMain(std::unique_ptr<Args>& args)
{
	// Setup Window:
	set_title("Simple Netaid");
	set_border_width(5);
	set_default_size(450, 350);
	set_position(Gtk::WIN_POS_CENTER);
	set_default_icon_from_file(args->APP_ICON);
	
	m_StatusIcon = new myStatusIcon(this, args);
	
	add(m_VBox);
	
	// MENUBAR:
	m_Menubar = new myMenuBar(this, args);
	m_VBox.pack_start(*m_Menubar, Gtk::PACK_SHRINK);
	
	// TOOLBAR:
	m_Toolbar = new myToolbar(this, args);
	m_VBox.pack_start(*m_Toolbar, Gtk::PACK_SHRINK);

	show_all_children();
}

WindowMain::~WindowMain()
{
	hide();
	if(m_StatusIcon) delete m_StatusIcon;	
	if(m_Menubar) delete m_Menubar;	
	if(m_Toolbar) delete m_Toolbar;
}

bool WindowMain::on_delete_event(GdkEventAny* /* event */)
{
	minimize();
	return true;
}

void WindowMain::minimize()
{
	iconify();
	set_skip_taskbar_hint(); // "hide" the window
}
