/*
 * window_main.h
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */
 

#ifndef __WINDOW_MAIN_H__
#define __WINDOW_MAIN_H__

// Forward declarations:
class Args;
class myStatusIcon;
class myMenuBar;
class myToolbar;

class WindowMain : public Gtk::Window
{
public:
	WindowMain(std::unique_ptr<Args>&);
	virtual ~WindowMain();
  
private:
	// Child widgets:
	Gtk::VBox m_VBox;
	myStatusIcon *m_StatusIcon;
	myMenuBar *m_Menubar;
	myToolbar *m_Toolbar;
	
	void minimize();
	bool on_delete_event(GdkEventAny* /* event */);
	
	// Friend function - Statusicon (GTK+) callback:
	friend void on_statusicon_activated(GtkWidget*, gpointer);
};

#endif // __WINDOW_MAIN_H__
