 /*
 * main.cpp
 * Copyright (C) Aitor Cuadrado Zubizarreta <aitor_czr@gnuinos.org>
 * 
 * simple-netaid is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * simple-netaid is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * See the COPYING file. * 
 */


#include <gtkmm.h>
#include <vector>
#include <iostream>
#include <memory>

#include "gtk/window_main.h"
#include "gtk/pipe_file.h"
#include "gtk/args.h"

Gtk::StockID stock_1;
Gtk::StockID stock_2;

int main (int argc , char **argv)
{	
	PipeFile *fp = new PipeFile();	
	std::vector<std::string> output = fp->get_output("ps -A | grep simple-netaid");
	if(fp) delete fp;
	
	if(output.size() > 1)
		throw std::runtime_error("Another instance of simple-netaid is already running.\n");
	
	std::unique_ptr<Args> args( new Args(argc, argv) );
		
	Gtk::Main kit(argc , argv); 
 
	WindowMain *pWindow_Main = new WindowMain(args);
  
	if(pWindow_Main) kit.run(*pWindow_Main);
 
	return EXIT_SUCCESS;
}
